library(ggplot2)
library(xlsx)
library(rstatix)
library(ggpubr)

data <- read.xlsx('Leg_Neck_Lengths.xlsx', sheetIndex = 1)
data$Breed2 <- data$Breed

###Plot figure showing limb and neck integration

tiff(filename = "Leg_Neck_Corr.tif", compression = "lzw", width = 222, height = 166, units = "mm", res = 600) #166x166*2 or 166x166*1.5

ggplot(data, aes(x=Ln_Neck)) +
  geom_smooth(aes(y = Ln_Tot, color = "black"), linetype = 1, method = "lm", se = FALSE, size = 0.8) +
  geom_smooth(aes(y = Ln_Func, color = "black"), linetype = 2, method = "lm", se = FALSE, size = 0.8) +
  geom_point(aes(y = Ln_Tot, shape = Breed, fill = Breed), size = 2.5) +
  geom_point(aes(y = Ln_Func, shape = Breed2, color = Breed), size = 2, stroke = 1.2) +
  theme(panel.grid.major = element_blank(), panel.grid.minor = element_blank(), panel.background = element_blank(), axis.line = element_line(colour = "black")) +
  #theme(legend.key=element_rect(fill="white")) +
  theme(legend.position="none") +
  xlab("Log Neck Length (mm)") + 
  ylab("Log Hindlimb Length (mm)") +
  scale_fill_manual(values = c("Mallard" = "lightyellow2",
                               "Aylesbury"="sienna3",
                               "Runner"="skyblue4")) +
  scale_shape_manual(values = c(21, 22, 23, 21, 1, 5)) +
  #scale_shape_manual(values = c(21, 1, 5)) +
  scale_color_manual(values = c('sienna3', 'black', 'lightyellow3', 'skyblue4'), guide = 'none')

dev.off()

###Linear Regression of functional and total limb length against neck length

func <- lm(Ln_Neck ~ Ln_Func, data = data)
summary(func)

tot <- lm(Ln_Neck ~ Ln_Tot, data = data)
summary(tot)
